; =========================================================================================== ;
; (pz:INI-Set file section key value)                                                         ;
;  file    [sTR] - short or full path file name                                               ;
;  section [sTR] - name of section to set key value                                           ;
;  key     [sTR] - name of key to set value                                                   ;
;  value   [sTR] - value to set                                                               ;
; ------------------------------------------------------------------------------------------- ;
; If section not found then function will create section with given key and value             ;
; If key in given section not found, function will create key with supplied value in section  ;
; ------------------------------------------------------------------------------------------- ;
; (pz:INI-Set "example.ini" "SECTION1" "KEY2" "Value 1_2")                                    ;
; =========================================================================================== ;
(defun pz:INI-Set ( file section key value / l sl fvalue i )
 (if
   (and
     (=(type file) 'STR)
     (=(type section) 'STR)
     (=(type key) 'STR)
     (=(type value) 'STR)
     (setq section (strcat "[" section "]"))
     (setq l (pz:INI-Read file))
   )
   (progn
     (if (setq sl (pz:AssocCI section l))
       (setq 
         sl (cdr sl)
         sl 
         (if (pz:AssocCI key sl)
           (progn
             (setq 
               fvalue (vl-string-subst value (pz:TrimStr(cadr(pz:AssocCI key sl))) (cadr(pz:AssocCI key sl)))
             )
             (subst 
               (list (car(pz:AssocCI key sl)) fvalue)
               (pz:AssocCI key sl)
               sl
             )
           )
           (progn
             (setq i (1-(length sl)))
             (while (= (length(nth i sl)) 1)
               (setq i (1- i))
             )
             (cd:LST_InsertItem (1+ i) sl (list key value))
           )
         )
         l (subst (cons (car(pz:AssocCI section l)) sl) (pz:AssocCI section l) l)
       )
       (setq l (reverse (append (list(list (car(pz:AssocCI section l)) (list key value))) (reverse l) )))
     )
     (if (and (setq file (findfile file)) (setq file (open file "w")))
       (progn
         (foreach %1 l
           (if (= (type (car %1)) 'STR)
             (progn
               (write-line (car %1) file)
               (foreach key (cdr %1)
                 (write-line (if (cadr key) (strcat (car key) "=" (cadr key)) (car key)) file)
               )
             )
             (foreach key %1
               (write-line (if (cadr key) (strcat (car key) "=" (cadr key)) (car key)) file)
             )
           )
         )
         (not (close file))
       )
     )
   )
   nil
 )
)

; =========================================================================================== ;
; Subroutines                                                                                 ;
; =========================================================================================== ;
(defun pz:TrimStr ( s )
 (vl-string-trim " \t" s)
)
(defun pz:AssocCI (e l / )
 (vl-some 
   '(lambda (%1) 
     (if 
       (and 
         (= (type (car %1)) 'STR) 
         (= (strcase e) (strcase (pz:TrimStr(car %1) )) )
       )
       %1
     )
   )
   l
 )
)
(defun pz:INI-Read ( f / l res sub i )
 (if 
   (and
     (setq l (cd:SYS_ReadFile nil f))
     (= (type l) 'LIST)
   )
   (progn
     (foreach %1 l
       (cond
         ( (and 
             (/= (substr (pz:TrimStr %1) 1 1) ";")
             (/= (substr (pz:TrimStr %1) 1 1) "#")
             (wcmatch (pz:TrimStr %1) "`[*`]")
           )
           (if sub 
             (setq res (cons (reverse sub) res))
           )
           (setq sub (list %1))
         )
         ( (and 
             (/= (substr (pz:TrimStr %1) 1 1) ";")
             (/= (substr (pz:TrimStr %1) 1 1) "#")
             (wcmatch %1 "*=*")
           )
           (setq i 0)
           (while (/= "=" (substr %1 (setq i (1+ i)) 1)))
           (setq sub (cons (list (substr %1 1 (1- i)) (substr %1 (1+ i))) sub))
         )
         ((setq sub (cons (list %1) sub)))
       )
     )
     (if sub (setq res (cons (reverse sub) res)))
   )
 )
 (reverse res)
)

; =========================================================================================== ;
; Subroutines from:                                                                           ;
; CADPL-Pack-v1.lsp                                                                           ;
; =========================================================================================== ;

; =========================================================================================== ;
; Czyta plik tekstowy / Read a text file                                                      ;
;  Line [iNT/nil] - INT = numer linii pliku / file line number                                ;
;                   nil = caly plik / all lines of file                                       ;
;  File [sTR]     - nazwa pliku (krotka lub ze sciezka) / short or full path file name        ;
; ------------------------------------------------------------------------------------------- ;
; Zwraca / Return:                                                                            ;
;   nil = gdy Line = INT wieksze niz ilosc linii w pliku lub plik jest pusty /                ;
;         when Line = INT is greater then number of lines in file or file is empty            ;
;     0 = brak dostepu do pliku / no access to file                                           ;
;    -1 = nie znaleziono pliku / file not found                                               ;
;   STR = gdy Line = INT / when Line = INT                                                    ;
;  LIST = gdy Line = nil / when Line = nil                                                    ;
; ------------------------------------------------------------------------------------------- ;
; (cd:SYS_ReadFile nil "data.ini"), (cd:SYS_ReadFile 10 "acad.lin")                           ;
; =========================================================================================== ;
(defun cd:SYS_ReadFile (Line File / fn fd l res)
 (if (setq fn (findfile File))
   (if (setq fd (open fn "r"))
     (progn
       (if Line
         (progn
           (repeat Line (read-line fd))
           (setq res (read-line fd))
         )
         (progn
           (setq l T)
           (while l
             (setq res
               (cons
                 (setq l (read-line fd))
                 res
               )
             )
           )
           (setq res (reverse (cdr res)))
         )
       )
       (close fd)
     )
     (setq res 0)
   )
   (setq res -1)
 )
 res
)
; =========================================================================================== ;
; Wstawia nowy element na liste / Inserts a new item in the list                              ;
;  Pos [iNT]  - pozycja elementu / element position                                           ;
;  Lst [list] - lista wejsciowa / input list                                                  ;
;  New [list/INT/REAL/STR/ENAME] - nowy element / new item                                    ;
; ------------------------------------------------------------------------------------------- ;
; (cd:LST_InsertItem 3 (list 0 1 2 4 5) 3)                                                    ;
; =========================================================================================== ;
(defun cd:LST_InsertItem (Pos Lst New / res)
 (if (< -1 Pos (1+ (length Lst)))
   (progn
     (repeat Pos
       (setq res (cons (car Lst) res)
             Lst (cdr Lst)
       )
     )
     (append (reverse res) (list New) Lst)
   )
   Lst
 )
)

(defun c:cfgINI-Set ()
; (vl-load-com)

(if (= "" (getvar 'CCONFIGURATION))
  (progn
    (pz:INI-Set (strcat (getvar "ROAMABLEROOTPREFIX") "\\config\\cfg.ini") (strcat "\\Configuration\\" (getvar "CPROFILE") "\\Appload\\Startup") "Loader" "sC:\\Acad_user\\AutoCaption.lsp")
	
  	
	(alert "!  NanoCAD.")
  )
)

)
